Database.events = [
    { // Send Piracy Email
        id: "4979f264-ffb6-4eee-a24e-ee715d878545",
        completable: true,
        trigger: (rootScope) => {
            if(rootScope.daysPlayed > 30 && !rootScope.options.informedAboutPiracy) {
                rootScope.sendMail("Jonas", Helpers.GetLocalized("piracymail_subject"), Helpers.GetLocalized("piracymail_body"));
                rootScope.options.informedAboutPiracy = true;
                rootScope.saveOptions();
                return true;
            }
        },
    },
    { // Send Last Tier Email
        id: "08be96dd-bb97-4a26-a36b-e3eb6d9d52d7",
        completable: true,
        trigger: (rootScope) => {
            if(rootScope.tierInfo != null && rootScope.tierInfo.currentTier >= 20) {
                rootScope.sendMail("Jonas", Helpers.GetLocalized("lasttiermail_subject"), Helpers.GetLocalized("lasttiermail_body"));
                return true;
            }
        },
    },
    { // Send Low Balance Warning
        id: "61a1f504-6c82-490b-a284-de7182d3eda0",
        completable: true,
        trigger: (rootScope) => {
            if (rootScope.settings.informedAboutCredit == null && rootScope.settings.balance < 0) {
                rootScope.settings.informedAboutCredit = true;
                rootScope.showMessage("", Helpers.GetLocalized('bank_ran_out_money', {amount: numeral(10000).format(Configuration.CURRENCY_FORMAT)}));
                return true;
            }
        },
    },
    { // Execute Game Over
        id: "b3d75c3a-a182-4718-8700-124f0f744a31",
        completable: true,
        trigger: (rootScope) => {
            if (rootScope.settings.balance <= -10000) {
                Game.Lifecycle.PauseTime(false, true);
                rootScope.settings.gameover = true;
                return true;
            }
        },
    },
];



